import logging
import struct
# from homeassistant.components.bluetooth import async_last_service_info
#from habluetooth import BaseHaScanner, BluetoothScannerDevice, BluetoothScanningMode, HaBleakScannerWrapper
#from habluetooth.scanner import HaScanner
from homeassistant.components import bluetooth
from homeassistant.components.bluetooth import BluetoothServiceInfoBleak, async_discovered_service_info
from bleak.backends.device import BLEDevice
from home_assistant_bluetooth import BluetoothServiceInfoBleak
#from bleak import BleakError, BleakScanner
from homeassistant.components.sensor import SensorEntity, SensorDeviceClass, SensorEntityDescription, SensorStateClass
from homeassistant.config_entries import ConfigEntry
from homeassistant.const import UnitOfVolume, SIGNAL_STRENGTH_DECIBELS_MILLIWATT, EntityCategory
from homeassistant.core import HomeAssistant
from homeassistant.helpers.entity_platform import AddEntitiesCallback
from homeassistant.helpers.restore_state import RestoreEntity
from homeassistant.const import CONF_ADDRESS, CONF_PIN, PERCENTAGE

# from . import ATickDataUpdateCoordinator
# from .base_entity import BaseEntity
from .const import DOMAIN, DEFAULT_PIN_DEVICE

_LOG = logging.getLogger(__name__)

TYPE_COUNTER_A = "counter_a_value"
TYPE_COUNTER_B = "counter_b_value"

ENTITIES: list[SensorEntityDescription] = [
    SensorEntityDescription(
        key=TYPE_COUNTER_A,
        translation_key=TYPE_COUNTER_A,
        name="Channel A",
        device_class=SensorDeviceClass.WATER,
        native_unit_of_measurement=UnitOfVolume.CUBIC_METERS,
        state_class = SensorStateClass.TOTAL_INCREASING,
        suggested_display_precision=2
    ),
    SensorEntityDescription(
        key=TYPE_COUNTER_B,
        translation_key=TYPE_COUNTER_B,
        name="Channel B",
        device_class=SensorDeviceClass.WATER,
        native_unit_of_measurement=UnitOfVolume.CUBIC_METERS,
        state_class=SensorStateClass.TOTAL_INCREASING,
        suggested_display_precision=2
    ),
    SensorEntityDescription(
        key="battery",
        translation_key="battery_level",
        name="Battery",
        device_class=SensorDeviceClass.BATTERY,
        native_unit_of_measurement=PERCENTAGE,
        state_class=SensorStateClass.MEASUREMENT,
        suggested_display_precision=0,
        entity_category=EntityCategory.DIAGNOSTIC
    ),
    SensorEntityDescription(
        key="rssi",
        translation_key="bluetooth_rssi",
        name="RSSI",
        device_class=SensorDeviceClass.SIGNAL_STRENGTH,
        native_unit_of_measurement=SIGNAL_STRENGTH_DECIBELS_MILLIWATT,
        state_class=SensorStateClass.MEASUREMENT,
        suggested_display_precision=0,
#        entity_registry_enabled_default=False,
        entity_category=EntityCategory.DIAGNOSTIC
    )
]

async def async_setup_entry(hass: HomeAssistant, entry: ConfigEntry, async_add_entities: AddEntitiesCallback) -> None:
    # coordinator: ATickDataUpdateCoordinator = hass.data[DOMAIN][entry.entry_id]

    #_LOG.info("SENSOR [%s] !!!!!!!!!!!", entry.entry_id)

    # bleak_scanner = bluetooth.async_get_scanner(hass)
    # devices = await bleak_scanner.discover()
    #_LOG.info(".. bleak: %s", devices)
    # if len(devices) == 0:
    #     _LOGGER.error("Could not find any bluetooth devices")
    # else:
    #     _LOG.info(".. bleak: %s", devices )

    sensors = [
        #ATickRSSISensor(coordinator)
    ]

    for description in ENTITIES:
        sensors.append(ATickWaterCounterSensor(description, entry))
        # sensors.append(ATickWaterCounterSensor(coordinator, description))

    async_add_entities(sensors)

# class ATickWaterCounterSensor(BaseEntity, SensorEntity, RestoreEntity):
class ATickWaterCounterSensor(SensorEntity, RestoreEntity):    
    # def __init__(self, coordinator: ATickDataUpdateCoordinator, sensor_description: SensorEntityDescription) -> None:
    def __init__(self, sensor_description: SensorEntityDescription, entry: ConfigEntry) -> None:    
        # super().__init__(coordinator)
        self._address = entry.data[CONF_ADDRESS]
        self._pin :int = DEFAULT_PIN_DEVICE
        self._index :int = ENTITIES.index(sensor_description);
        try:
            self._pin = int(entry.data[CONF_PIN])
        except ValueError:
            _LOG.error("wrong PIN code: '%s', use defualt sens init %s", entry.data[CONF_PIN])

        self.entity_description = sensor_description

        # self._attr_unique_id = f"{self._device.base_unique_id}-{self.entity_description.key}"
        self._attr_unique_id = f"{entry.entry_id}-{self.entity_description.key}"
        # self._attr_name = self._device.name + ' ' + self.entity_description.name
        self._attr_name = 'aTick ' + self.entity_description.name
        if self._index == 2 :
            self._attr_icon = "mdi:battery-70-bluetooth"
        else:
            if self._index == 3 :
                self._attr_icon = "mdi:signal"
            else:
                self._attr_icon = "mdi:counter"      

        # self._attr_icon = "mdi:counter"
        #_LOG.info("sens '%s' [%i] init %s", self._attr_name, self._index, self._address)

        self._attr_device_class = self.entity_description.device_class
        self._attr_native_unit_of_measurement = self.entity_description.native_unit_of_measurement
        self._attr_state_class = self.entity_description.state_class
        self._attr_suggested_display_precision = self.entity_description.suggested_display_precision

    @property
    def native_value(self) -> float | None:        
        # return self._device.data[self.entity_description.key]
        #_LOG.info("SENSOR get value for (%s) [%s] !!!!!!!!!!!", self._attr_unique_id, self._attr_name)
        res = GetDecodedValues(self)
        if res is None:
            return None
        return res[self._index]

# ищем нужный девайс и разбираем байтики рекламной посылки ...
def GetDecodedValues(self) : # -> float | None :
    #_LOG.info("---- Decode Value [%i] (%i): %s ... ", index, len(data), data)

    for discovery in async_discovered_service_info(self.hass):

        if discovery.address == self._address:  
            _LOG.debug("DI[%s] : rssi:%s  mfd: %s", discovery.address, discovery.rssi, discovery.manufacturer_data)
            i = 0
            data_bytes = []
            for key, value in discovery.manufacturer_data.items():
                print(key, value)
                data = []
                data.append(key & 0xFF)
                data.append(key >> 8)
                for b in value:
                    data.append(b)
                #hex_string =' '.join(format(byte, '02x') for byte in data_bytes)
                #_LOG.info("Data [%i] (%i): %s", i, len(data_bytes), hex_string)
                i = i + 1

            if i > 0 :
                # val = self.GetDecodedValue(self._index, data_bytes)
                # res = GetDecodedValues(self, data_bytes)
                if len(data) != 11 :
                    return None

                #_LOG.info("Len OK! ")

                # проверим префикс ...
                asum = 0
                i = 0
                while i < (len(self._address) - 1) :
                    asum += int(self._address[i : (i + 2)], 16)
                    i += 3

                sum =  (0x54 + asum) & 0xFF

                if data[0] != sum :
                    _LOG.error("Prefix ERROR %02X != %02X", data[0] , sum)
                    return None
    
                #_LOG.info("Prefix OK! ")

                flags:int = data[9]
                isClicked: bool = (flags & 1) != 0
                isCrypted: bool = (flags & 16) != 0
                VdcPercent3bit: int = ((flags >> 5) & 7) * 100 / 7

                #_LOG.info("FLAGSS: clicked: %i crypted: %i  vdc: %i ", self._isClicked, self._isCrypted, self._VdcPercent3bit)

                if isCrypted :
                    pin :int = self._pin
                    #  посчитаем байт-ключ KEY ...
                    key:int = asum
                    for i in range(3):
                        print(i)  # Output: 0, 1, 2, 3, 4
                        key += (( pin >> (i * 8)) & 0xFF)
                    key = (((key ^ 0xFF) + 1) & 0xFF)
                    # декодим данные по ключу ...
                    for i in range(1, 9, 1):
                        data[i] = (((data[i]) ^ key) & 0xFF)

                # проверим соответствие данных ...
                crc:int = 0
                for i in range(10):
                    crc += data[i]
                isValid = (crc & 0xFF) == data[10]

                #_LOG.info("CRC: is: %i ", self._isValid)

                if not isValid:
                    _LOG.error("CRC: %i is not valid!", self._isValid)
                    return None

                chanA : float = None
                chanB : float = None
                # i:int = index * 4 + 1
                try:
                    # vf = struct.unpack('<f', bytearray(data[i:(i + 4)]))[0]
                    chanA = struct.unpack('<f', bytearray(data[1:5]))[0]
                    chanB = struct.unpack('<f', bytearray(data[5:9]))[0]
                except struct.error:
                    _LOG.error("Float value error!")
                    return None
                _LOG.debug("**** values: A:%f  B:%f ********* ", chanA, chanB)
                return chanA, chanB, VdcPercent3bit, discovery.rssi, isCrypted, isClicked
            break
    return None






